/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api;

import filenet.vw.base.logging.Logger;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSMember;
import filenet.ws.api.WSPart;
import filenet.ws.api.WSTemplateBase;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.xml.namespace.QName;

public class WSMessage
extends WSTemplateBase {
    protected static Logger logger = Logger.getLogger("filenet.ws.api");
    protected static final String m_className = "WSMessage";
    private WSDefinition m_definition = null;
    private Message m_message = null;
    private WSPart[] m_parts = null;
    private String[] m_nameSpaces = null;

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 10:00:26  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.27  $";
    }

    public void releaseReferences() {
        block6: {
            try {
                this.m_definition = null;
                this.m_message = null;
                if (this.m_parts != null) {
                    WSPart part = null;
                    WSPart[] parts = this.m_parts;
                    this.m_parts = null;
                    for (int i = 0; i < parts.length; ++i) {
                        if (parts[i] == null) continue;
                        part = parts[i];
                        parts[i] = null;
                        part.releaseReferences();
                        part = null;
                    }
                    parts = null;
                }
                if (this.m_nameSpaces != null) {
                    String[] namespaces = this.m_nameSpaces;
                    this.m_nameSpaces = null;
                    for (int i = 0; i < namespaces.length; ++i) {
                        namespaces[i] = null;
                    }
                    namespaces = null;
                }
                super.releaseReferences();
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block6;
                logger.throwing(m_className, "releaseReferences", ex);
            }
        }
    }

    public WSMessage(WSDefinition definition, Message message) {
        Map map;
        this.m_definition = definition;
        this.m_message = message;
        if (this.m_message != null && (map = this.m_message.getParts()) != null && map.size() > 0) {
            this.m_parts = new WSPart[map.size()];
            Collection inParts = map.values();
            Iterator it = inParts.iterator();
            WSPart part = null;
            if (it != null) {
                int i = 0;
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (obj == null || !(obj instanceof Part)) continue;
                    part = new WSPart(this.m_definition, (Part)obj);
                    this.m_parts[i++] = part;
                }
            }
        }
    }

    public QName getQName() {
        if (this.m_message != null) {
            return this.m_message.getQName();
        }
        return null;
    }

    public String getName() {
        if (this.m_message != null) {
            return this.m_message.getQName().getLocalPart();
        }
        return null;
    }

    public Message getMessage() {
        return this.m_message;
    }

    public WSPart[] getParts() {
        return this.m_parts;
    }

    public String getDisplayName() {
        if (this.m_message != null) {
            return this.m_message.getQName().getLocalPart();
        }
        return null;
    }

    protected void initMembers() {
        String m_method = "initMembers()";
        if (this.m_members == null && this.m_parts != null && this.m_parts.length > 0) {
            int i;
            if (this.m_members == null) {
                Vector<WSMember> members = new Vector<WSMember>();
                WSMember member = null;
                this.m_members = new WSMember[this.m_parts.length];
                for (i = 0; i < this.m_parts.length; ++i) {
                    if (this.m_parts[i] == null || this.m_parts[i].getDefinition() == null) continue;
                    member = this.m_parts[i].getDefinition().getMember(this.m_parts[i]);
                    if (member == null) {
                        member = this.m_parts[i].getDefinition().newMember(this.getNamespace(), (Object)this.m_parts[i]);
                    }
                    if (member == null) continue;
                    if (member.isBaseType() || member.isCollectionElement() || member.isEnum() || member.isChoice() || member.getMemberCount() > 0) {
                        members.add(member);
                        continue;
                    }
                    if (!member.isPartMember()) continue;
                    member.setBlankType(true);
                    members.add(member);
                }
                if (members != null && members.size() > 0) {
                    this.m_members = new WSMember[members.size()];
                    members.toArray(this.m_members);
                    members.clear();
                }
            }
            if (this.m_members != null && this.m_members.length > 0) {
                Vector v = new Vector();
                Object nameSpace = null;
                for (i = 0; i < this.m_members.length; ++i) {
                    if (this.m_members[i] == null) continue;
                    this.m_members[i].addNameSpace(v);
                }
                if (v != null && v.size() > 0) {
                    this.m_nameSpaces = new String[v.size()];
                    v.toArray(this.m_nameSpaces);
                    v.clear();
                }
            }
        }
    }

    public String getXMLMessageTemplate(String[] paramOrdering) throws Exception {
        return this.toXMLTemplate(paramOrdering);
    }

    public String getXMLMessageTemplate() throws Exception {
        return this.getXMLMessageTemplate(null);
    }

    public String getExpressionMessageTemplate(String[] paramOrdering) throws Exception {
        return this.toXMLTemplateExpression(paramOrdering);
    }

    public String getExpressionMessageTemplate() throws Exception {
        return this.getExpressionMessageTemplate(null);
    }

    WSDefinition getDefinition() {
        return this.m_definition;
    }

    String getNamespace() {
        if (this.m_message != null && this.m_message.getQName() != null) {
            return this.m_message.getQName().getNamespaceURI();
        }
        return null;
    }

    String[] getNameSpaces() {
        this.initMembers();
        return this.m_nameSpaces;
    }

    protected String getTemplateNamespace() {
        return null;
    }

    protected String getTemplateRootName() {
        return this.getDisplayName();
    }

    public String toString() {
        String s = new String();
        s = s + "***************** WSMessage****************\n";
        s = s + "message name: " + this.m_message.getQName().getLocalPart() + "\n";
        s = s + "namespace: " + this.m_message.getQName().getNamespaceURI() + "\n";
        s = s + super.toString();
        s = s + "*****************\n";
        return s;
    }
}

